/*
 * Decompiled with CFR 0.152.
 */
package cn.com.scca.signgw.api;

import cn.com.scca.http.Consts;
import cn.com.scca.http.HttpEntity;
import cn.com.scca.http.client.methods.CloseableHttpResponse;
import cn.com.scca.http.client.methods.HttpPost;
import cn.com.scca.http.client.methods.HttpUriRequest;
import cn.com.scca.http.entity.ContentType;
import cn.com.scca.http.entity.mime.MultipartEntityBuilder;
import cn.com.scca.http.impl.client.CloseableHttpClient;
import cn.com.scca.http.impl.client.HttpClients;
import cn.com.scca.http.util.EntityUtils;
import cn.com.scca.signgw.api.utils.MessageUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class SccaGwSDK {
    private static String baseUrl = "";
    private static final ContentType TEXT_XML = ContentType.create((String)"text/xml", (Charset)Consts.UTF_8);

    public static void init(String url) {
        baseUrl = url;
    }

    private static boolean checkUrlIsNull() {
        return baseUrl == null || "".equals(baseUrl);
    }

    public static String certLogin(String projectId, String toSign, String signedData, String reqId) {
        try {
            if (SccaGwSDK.checkUrlIsNull()) {
                return MessageUtils.getErrorMsg("\u8bf7\u5148\u8c03\u7528init\u65b9\u6cd5\u521d\u59cb\u5316URL", reqId);
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("projectId", projectId);
            paramMap.put("toSign", toSign);
            paramMap.put("signedData", signedData);
            paramMap.put("reqId", reqId);
            paramMap.put("version", "1");
            String requestUrl = String.valueOf(baseUrl) + "/" + "api/signature/certLogin";
            String result = SccaGwSDK.postStringData(paramMap, null, requestUrl);
            if ("NO_DATA".equals(result)) {
                return MessageUtils.getErrorMsg("\u6ca1\u6709\u8fd4\u56de\u4efb\u4f55\u6570\u636e,\u8bf7\u68c0\u67e5", reqId);
            }
            return result;
        }
        catch (Exception ex) {
            return MessageUtils.getErrorMsg(ex.getMessage(), reqId);
        }
    }

    public static String validateSignaturePkcs7(String projectId, String toSign, String signedData, String opType, String reqId) {
        try {
            if (SccaGwSDK.checkUrlIsNull()) {
                return MessageUtils.getErrorMsg("\u8bf7\u5148\u8c03\u7528init\u65b9\u6cd5\u521d\u59cb\u5316URL", reqId);
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("projectId", projectId);
            paramMap.put("toSign", toSign);
            paramMap.put("signedData", signedData);
            paramMap.put("opType", opType);
            paramMap.put("reqId", reqId);
            paramMap.put("version", "1");
            String requestUrl = String.valueOf(baseUrl) + "/" + "api/signature/verifyPkcs7";
            String result = SccaGwSDK.postStringData(paramMap, null, requestUrl);
            if ("NO_DATA".equals(result)) {
                return MessageUtils.getErrorMsg("\u6ca1\u6709\u8fd4\u56de\u4efb\u4f55\u6570\u636e,\u8bf7\u68c0\u67e5", reqId);
            }
            return result;
        }
        catch (Exception ex) {
            return MessageUtils.getErrorMsg(ex.getMessage(), reqId);
        }
    }

    public static String validateFileSignaturePkcs7(String projectId, String file, String signedData, String opType, String reqId) {
        try {
            if (SccaGwSDK.checkUrlIsNull()) {
                return MessageUtils.getErrorMsg("\u8bf7\u5148\u8c03\u7528init\u65b9\u6cd5\u521d\u59cb\u5316URL", reqId);
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("projectId", projectId);
            paramMap.put("signedData", signedData);
            paramMap.put("opType", opType);
            paramMap.put("reqId", reqId);
            paramMap.put("version", "1");
            HashMap<String, String> fileMap = new HashMap<String, String>();
            fileMap.put("uploadSignFile", file);
            String requestUrl = String.valueOf(baseUrl) + "/" + "api/signature/verifyFilePkcs7";
            String result = SccaGwSDK.postStringData(paramMap, fileMap, requestUrl);
            if ("NO_DATA".equals(result)) {
                return MessageUtils.getErrorMsg("\u6ca1\u6709\u8fd4\u56de\u4efb\u4f55\u6570\u636e,\u8bf7\u68c0\u67e5", reqId);
            }
            return result;
        }
        catch (Exception ex) {
            return MessageUtils.getErrorMsg(ex.getMessage(), reqId);
        }
    }

    public static String parseCertBase64(String certBase64) {
        try {
            if (SccaGwSDK.checkUrlIsNull()) {
                return MessageUtils.getErrorMsg("\u8bf7\u5148\u8c03\u7528init\u65b9\u6cd5\u521d\u59cb\u5316URL", "-1");
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("certBase64", certBase64);
            String requestUrl = String.valueOf(baseUrl) + "/" + "api/cert/parseCert";
            String result = SccaGwSDK.postStringData(paramMap, null, requestUrl);
            if ("NO_DATA".equals(result)) {
                return MessageUtils.getErrorMsg("\u6ca1\u6709\u8fd4\u56de\u4efb\u4f55\u6570\u636e,\u8bf7\u68c0\u67e5", "-1");
            }
            return result;
        }
        catch (Exception ex) {
            return MessageUtils.getErrorMsg(ex.getMessage(), "-1");
        }
    }

    public static String validateCertBase64(String certBase64) {
        try {
            if (SccaGwSDK.checkUrlIsNull()) {
                return MessageUtils.getErrorMsg("\u8bf7\u5148\u8c03\u7528init\u65b9\u6cd5\u521d\u59cb\u5316URL", "-1");
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("certBase64", certBase64);
            String requestUrl = String.valueOf(baseUrl) + "/" + "api/cert/validateCert";
            String result = SccaGwSDK.postStringData(paramMap, null, requestUrl);
            if ("NO_DATA".equals(result)) {
                return MessageUtils.getErrorMsg("\u6ca1\u6709\u8fd4\u56de\u4efb\u4f55\u6570\u636e,\u8bf7\u68c0\u67e5", "-1");
            }
            return result;
        }
        catch (Exception ex) {
            return MessageUtils.getErrorMsg(ex.getMessage(), "-1");
        }
    }

    public static String postStringData(Map<String, String> paramMap, Map<String, String> fileMap, String requestUrl) throws Exception {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(requestUrl);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        if (fileMap != null) {
            for (Map.Entry<String, String> entry : fileMap.entrySet()) {
                multipartEntityBuilder.addBinaryBody(entry.getKey(), new File(entry.getValue()));
            }
        }
        if (paramMap != null) {
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                multipartEntityBuilder.addTextBody(entry.getKey(), entry.getValue(), TEXT_XML);
            }
        }
        multipartEntityBuilder.setCharset(StandardCharsets.UTF_8);
        HttpEntity reqEntity = multipartEntityBuilder.build();
        httpPost.setEntity(reqEntity);
        CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
        HttpEntity resEntity = response.getEntity();
        if (resEntity != null) {
            String body = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
            return body;
        }
        EntityUtils.consume((HttpEntity)resEntity);
        response.close();
        return "NO_DATA";
    }

    public static void main(String[] args) throws Exception {
        SccaGwSDK.init("http://127.0.0.1:9191/sign-gw");
        String signedData = "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";
        String result = SccaGwSDK.validateFileSignaturePkcs7("test", "C:\\Users\\Jack\\Desktop\\\u95ee\u9898.txt", signedData, "\u7cfb\u7edf\u767b\u9646", "765432");
        System.out.println(result);
    }
}

