/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xml.stream;

import com.bea.xml.stream.MXParser;
import java.io.FileReader;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;

public class ReadOnlyNamespaceContextBase
implements NamespaceContext {
    private String[] prefixes;
    private String[] uris;

    public ReadOnlyNamespaceContextBase(String[] prefixArray, String[] uriArray, int size) {
        this.prefixes = new String[size];
        this.uris = new String[size];
        System.arraycopy(prefixArray, 0, this.prefixes, 0, this.prefixes.length);
        System.arraycopy(uriArray, 0, this.uris, 0, this.uris.length);
    }

    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix may not be null.");
        }
        if (prefix.length() > 0) {
            for (int i = this.uris.length - 1; i >= 0; --i) {
                if (!prefix.equals(this.prefixes[i])) continue;
                return this.uris[i];
            }
            if ("xml".equals(prefix)) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            if ("xmlns".equals(prefix)) {
                return "http://www.w3.org/2000/xmlns/";
            }
        } else {
            for (int i = this.uris.length - 1; i >= 0; --i) {
                if (this.prefixes[i] != null) continue;
                return this.uris[i];
            }
        }
        return null;
    }

    public String getPrefix(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri may not be null");
        }
        if (uri.length() == 0) {
            throw new IllegalArgumentException("uri may not be empty string");
        }
        block0: for (int i = this.uris.length - 1; i >= 0; --i) {
            int j;
            if (!uri.equals(this.uris[i])) continue;
            String prefix = this.prefixes[i];
            if (prefix == null) {
                for (j = this.uris.length - 1; j > i; --j) {
                    if (this.prefixes[j] == null) continue block0;
                }
                return "";
            }
            for (j = this.uris.length - 1; j > i; --j) {
                if (prefix.equals(this.prefixes[j])) continue block0;
            }
            return prefix;
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(uri)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(uri)) {
            return "xmlns";
        }
        return null;
    }

    public String getDefaultNameSpace() {
        for (int i = this.uris.length - 1; i >= 0; --i) {
            if (this.prefixes[i] != null) continue;
            return this.uris[i];
        }
        return null;
    }

    private String checkNull(String s2) {
        if (s2 == null) {
            return "";
        }
        return s2;
    }

    public Iterator getPrefixes(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri may not be null");
        }
        if ("".equals(uri)) {
            throw new IllegalArgumentException("uri may not be empty string");
        }
        HashSet<String> s2 = new HashSet<String>();
        block0: for (int i = this.uris.length - 1; i >= 0; --i) {
            int j;
            String prefix = this.checkNull(this.prefixes[i]);
            if (!uri.equals(this.uris[i]) || s2.contains(prefix)) continue;
            if (prefix.length() == 0) {
                for (j = this.uris.length - 1; j > i; --j) {
                    if (this.prefixes[j] == null) continue block0;
                }
            } else {
                for (j = this.uris.length - 1; j > i; --j) {
                    if (prefix.equals(this.prefixes[j])) continue block0;
                }
            }
            s2.add(prefix);
        }
        return s2.iterator();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < this.uris.length; ++i) {
            b.append("[" + this.checkNull(this.prefixes[i]) + "<->" + this.uris[i] + "]");
        }
        return b.toString();
    }

    public static void main(String[] args) throws Exception {
        MXParser p = new MXParser();
        p.setInput(new FileReader(args[0]));
        while (p.hasNext()) {
            if (p.isStartElement()) {
                System.out.println("context[" + p.getNamespaceContext() + "]");
                Iterator i = p.getNamespaceContext().getPrefixes("a");
                while (i.hasNext()) {
                    System.out.println("Found prefix:" + i.next());
                }
            }
            p.next();
        }
    }
}

