/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import io.minio.CopyConditions;
import io.minio.S3Escaper;
import io.minio.ServerSideEncryption;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class ComposeSource {
    private String bucketName;
    private String objectName;
    private Long offset;
    private Long length;
    private Map<String, String> headerMap;
    private CopyConditions copyConditions;
    private ServerSideEncryption sse;
    private long objectSize;
    private Map<String, String> headers;

    public ComposeSource(String bucketName, String objectName) throws IllegalArgumentException {
        this(bucketName, objectName, null, null, null, null, null);
    }

    public ComposeSource(String bucketName, String objectName, Long offset, Long length) throws IllegalArgumentException {
        this(bucketName, objectName, offset, length, null, null, null);
    }

    public ComposeSource(String bucketName, String objectName, Long offset, Long length, Map<String, String> headerMap) throws IllegalArgumentException {
        this(bucketName, objectName, offset, length, headerMap, null, null);
    }

    public ComposeSource(String bucketName, String objectName, Long offset, Long length, Map<String, String> headerMap, CopyConditions copyConditions) throws IllegalArgumentException {
        this(bucketName, objectName, offset, length, headerMap, copyConditions, null);
    }

    public ComposeSource(String bucketName, String objectName, Long offset, Long length, Map<String, String> headerMap, CopyConditions copyConditions, ServerSideEncryption sse) throws IllegalArgumentException {
        if (bucketName == null) {
            throw new IllegalArgumentException("Source bucket name cannot be empty");
        }
        if (objectName == null) {
            throw new IllegalArgumentException("Source object name cannot be empty");
        }
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("Offset cannot be negative");
        }
        if (length != null && length < 0L) {
            throw new IllegalArgumentException("Length cannot be negative");
        }
        if (length != null && offset == null) {
            offset = 0L;
        }
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.offset = offset;
        this.length = length;
        this.headerMap = headerMap != null ? Collections.unmodifiableMap(headerMap) : null;
        this.copyConditions = copyConditions;
        this.sse = sse;
    }

    public void buildHeaders(long objectSize, String etag) throws IllegalArgumentException {
        if (this.offset != null && this.offset >= objectSize) {
            throw new IllegalArgumentException("source " + this.bucketName + "/" + this.objectName + ": offset " + this.offset + " is beyond object size " + objectSize);
        }
        if (this.length != null) {
            if (this.length > objectSize) {
                throw new IllegalArgumentException("source " + this.bucketName + "/" + this.objectName + ": length " + this.length + " is beyond object size " + objectSize);
            }
            if (this.offset + this.length > objectSize) {
                throw new IllegalArgumentException("source " + this.bucketName + "/" + this.objectName + ": compose size " + (this.offset + this.length) + " is beyond object size " + objectSize);
            }
        }
        TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        headers.put("x-amz-copy-source", S3Escaper.encodePath(this.bucketName + "/" + this.objectName));
        headers.put("x-amz-copy-source-if-match", etag);
        if (this.headerMap != null) {
            headers.putAll(this.headerMap);
        }
        if (this.copyConditions != null) {
            headers.putAll(this.copyConditions.getConditions());
        }
        if (this.sse != null) {
            headers.putAll(this.sse.copySourceHeaders());
        }
        this.objectSize = objectSize;
        this.headers = Collections.unmodifiableMap(headers);
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String objectName() {
        return this.objectName;
    }

    public Long offset() {
        return this.offset;
    }

    public Long length() {
        return this.length;
    }

    public CopyConditions copyConditions() {
        return this.copyConditions;
    }

    public ServerSideEncryption sse() {
        return this.sse;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public long objectSize() {
        return this.objectSize;
    }
}

