/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import io.minio.Time;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CopyConditions {
    private static final String METADATA_DIRECTIVE_REPLACE = "REPLACE";
    private Map<String, String> copyConditions = new HashMap<String, String>();

    public void setModified(ZonedDateTime time) throws IllegalArgumentException {
        if (time == null) {
            throw new IllegalArgumentException("modified time cannot be empty");
        }
        this.copyConditions.put("x-amz-copy-source-if-modified-since", time.format(Time.HTTP_HEADER_DATE_FORMAT));
    }

    public void setUnmodified(ZonedDateTime time) throws IllegalArgumentException {
        if (time == null) {
            throw new IllegalArgumentException("unmodified time can not be null");
        }
        this.copyConditions.put("x-amz-copy-source-if-unmodified-since", time.format(Time.HTTP_HEADER_DATE_FORMAT));
    }

    public void setMatchETag(String etag) throws IllegalArgumentException {
        if (etag == null) {
            throw new IllegalArgumentException("ETag cannot be empty");
        }
        this.copyConditions.put("x-amz-copy-source-if-match", etag);
    }

    public void setMatchETagNone(String etag) throws IllegalArgumentException {
        if (etag == null) {
            throw new IllegalArgumentException("ETag cannot be empty");
        }
        this.copyConditions.put("x-amz-copy-source-if-none-match", etag);
    }

    public void setReplaceMetadataDirective() {
        this.copyConditions.put("x-amz-metadata-directive", METADATA_DIRECTIVE_REPLACE);
    }

    public Map<String, String> getConditions() {
        return Collections.unmodifiableMap(this.copyConditions);
    }
}

