/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.io.ByteStreams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.minio.AwsS3Endpoints;
import io.minio.BucketRegionCache;
import io.minio.CloseableIterator;
import io.minio.ComposeSource;
import io.minio.CopyConditions;
import io.minio.Digest;
import io.minio.ErrorCode;
import io.minio.HttpRequestBody;
import io.minio.MinioProperties;
import io.minio.ObjectStat;
import io.minio.PostPolicy;
import io.minio.PutObjectOptions;
import io.minio.Result;
import io.minio.S3Escaper;
import io.minio.SelectResponseStream;
import io.minio.ServerSideEncryption;
import io.minio.Signer;
import io.minio.Time;
import io.minio.Xml;
import io.minio.errors.BucketPolicyTooLargeException;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidBucketNameException;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidExpiresRangeException;
import io.minio.errors.InvalidPortException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.RegionConflictException;
import io.minio.errors.XmlParserException;
import io.minio.http.Method;
import io.minio.http.Scheme;
import io.minio.messages.Bucket;
import io.minio.messages.CompleteMultipartUpload;
import io.minio.messages.CopyObjectResult;
import io.minio.messages.CopyPartResult;
import io.minio.messages.CreateBucketConfiguration;
import io.minio.messages.DeleteError;
import io.minio.messages.DeleteObject;
import io.minio.messages.DeleteRequest;
import io.minio.messages.DeleteResult;
import io.minio.messages.ErrorResponse;
import io.minio.messages.InitiateMultipartUploadResult;
import io.minio.messages.InputSerialization;
import io.minio.messages.Item;
import io.minio.messages.LegalHold;
import io.minio.messages.ListAllMyBucketsResult;
import io.minio.messages.ListBucketResult;
import io.minio.messages.ListBucketResultV1;
import io.minio.messages.ListMultipartUploadsResult;
import io.minio.messages.ListPartsResult;
import io.minio.messages.LocationConstraint;
import io.minio.messages.NotificationConfiguration;
import io.minio.messages.NotificationRecords;
import io.minio.messages.ObjectLockConfiguration;
import io.minio.messages.OutputSerialization;
import io.minio.messages.Part;
import io.minio.messages.Prefix;
import io.minio.messages.Retention;
import io.minio.messages.SelectObjectContentRequest;
import io.minio.messages.Upload;
import io.minio.org.apache.commons.validator.routines.InetAddressValidator;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class MinioClient {
    private static final byte[] EMPTY_BODY = new byte[0];
    private static final long DEFAULT_CONNECTION_TIMEOUT = 900L;
    private static final int MAX_BUCKET_POLICY_SIZE = 12288;
    private static final int DEFAULT_EXPIRY_TIME = 604800;
    private static final String DEFAULT_USER_AGENT = "MinIO (" + System.getProperty("os.arch") + "; " + System.getProperty("os.arch") + ") minio-java/" + MinioProperties.INSTANCE.getVersion();
    private static final String NULL_STRING = "(null)";
    private static final String S3_AMAZONAWS_COM = "s3.amazonaws.com";
    private static final String END_HTTP = "----------END-HTTP----------";
    private static final String US_EAST_1 = "us-east-1";
    private static final String UPLOAD_ID = "uploadId";
    private static final Set<String> amzHeaders = new HashSet<String>();
    private static final Set<String> standardHeaders;
    private PrintWriter traceStream;
    private HttpUrl baseUrl;
    private String accessKey;
    private String secretKey;
    private String region;
    private String userAgent = DEFAULT_USER_AGENT;
    private OkHttpClient httpClient;

    public MinioClient(String endpoint) throws InvalidEndpointException, InvalidPortException {
        this(endpoint, 0, null, null);
    }

    public MinioClient(URL url) throws InvalidEndpointException, InvalidPortException {
        this(url.toString(), 0, null, null);
    }

    public MinioClient(HttpUrl url) throws InvalidEndpointException, InvalidPortException {
        this(url.toString(), 0, null, null);
    }

    public MinioClient(String endpoint, String accessKey, String secretKey) throws InvalidEndpointException, InvalidPortException {
        this(endpoint, 0, accessKey, secretKey);
    }

    public MinioClient(String endpoint, String accessKey, String secretKey, String region) throws InvalidEndpointException, InvalidPortException {
        this(endpoint, 0, accessKey, secretKey, region, endpoint == null || !endpoint.startsWith("http://"));
    }

    public MinioClient(URL url, String accessKey, String secretKey) throws InvalidEndpointException, InvalidPortException {
        this(url.toString(), 0, accessKey, secretKey);
    }

    public MinioClient(HttpUrl url, String accessKey, String secretKey) throws InvalidEndpointException, InvalidPortException {
        this(url.toString(), 0, accessKey, secretKey);
    }

    public MinioClient(String endpoint, int port, String accessKey, String secretKey) throws InvalidEndpointException, InvalidPortException {
        this(endpoint, port, accessKey, secretKey, endpoint == null || !endpoint.startsWith("http://"));
    }

    public MinioClient(String endpoint, String accessKey, String secretKey, boolean secure) throws InvalidEndpointException, InvalidPortException {
        this(endpoint, 0, accessKey, secretKey, secure);
    }

    public MinioClient(String endpoint, int port, String accessKey, String secretKey, boolean secure) throws InvalidEndpointException, InvalidPortException {
        this(endpoint, port, accessKey, secretKey, null, secure);
    }

    public MinioClient(String endpoint, int port, String accessKey, String secretKey, String region, boolean secure) throws InvalidEndpointException, InvalidPortException {
        this(endpoint, port, accessKey, secretKey, region, secure, null);
    }

    public MinioClient(String endpoint, int port, String accessKey, String secretKey, String region, boolean secure, OkHttpClient httpClient) throws InvalidEndpointException, InvalidPortException {
        if (endpoint == null) {
            throw new InvalidEndpointException(NULL_STRING, "null endpoint");
        }
        if (port < 0 || port > 65535) {
            throw new InvalidPortException(port, "port must be in range of 1 to 65535");
        }
        if (httpClient != null) {
            this.httpClient = httpClient;
        } else {
            LinkedList<Protocol> protocol = new LinkedList<Protocol>();
            protocol.add(Protocol.HTTP_1_1);
            this.httpClient = new OkHttpClient();
            this.httpClient = this.httpClient.newBuilder().connectTimeout(900L, TimeUnit.SECONDS).writeTimeout(900L, TimeUnit.SECONDS).readTimeout(900L, TimeUnit.SECONDS).protocols(protocol).build();
        }
        HttpUrl url = HttpUrl.parse(endpoint);
        if (url != null) {
            if (!"/".equals(url.encodedPath())) {
                throw new InvalidEndpointException(endpoint, "no path allowed in endpoint");
            }
            HttpUrl.Builder urlBuilder = url.newBuilder();
            Scheme scheme = Scheme.HTTP;
            if (secure) {
                scheme = Scheme.HTTPS;
            }
            urlBuilder.scheme(scheme.toString());
            if (port > 0) {
                urlBuilder.port(port);
            }
            this.baseUrl = urlBuilder.build();
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            this.region = region;
            return;
        }
        if (!this.isValidEndpoint(endpoint)) {
            throw new InvalidEndpointException(endpoint, "invalid host");
        }
        Scheme scheme = Scheme.HTTP;
        if (secure) {
            scheme = Scheme.HTTPS;
        }
        this.baseUrl = port == 0 ? new HttpUrl.Builder().scheme(scheme.toString()).host(endpoint).build() : new HttpUrl.Builder().scheme(scheme.toString()).host(endpoint).port(port).build();
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.region = region;
    }

    private boolean isValidEndpoint(String endpoint) {
        if (InetAddressValidator.getInstance().isValid(endpoint)) {
            return true;
        }
        if (endpoint.length() < 1 || endpoint.length() > 253) {
            return false;
        }
        for (String label : endpoint.split("\\.")) {
            if (label.length() < 1 || label.length() > 63) {
                return false;
            }
            if (label.matches("^[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?$")) continue;
            return false;
        }
        return true;
    }

    private void checkBucketName(String name) throws InvalidBucketNameException {
        if (name == null) {
            throw new InvalidBucketNameException(NULL_STRING, "null bucket name");
        }
        if (name.length() < 3 || name.length() > 63) {
            String msg = "bucket name must be at least 3 and no more than 63 characters long";
            throw new InvalidBucketNameException(name, msg);
        }
        if (name.contains("..")) {
            String msg = "bucket name cannot contain successive periods. For more information refer http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html";
            throw new InvalidBucketNameException(name, msg);
        }
        if (!name.matches("^[a-z0-9][a-z0-9\\.\\-]+[a-z0-9]$")) {
            String msg = "bucket name does not follow Amazon S3 standards. For more information refer http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html";
            throw new InvalidBucketNameException(name, msg);
        }
    }

    private void checkObjectName(String objectName) throws IllegalArgumentException {
        if (objectName == null || objectName.isEmpty()) {
            throw new IllegalArgumentException("object name cannot be empty");
        }
    }

    private void checkReadRequestSse(ServerSideEncryption sse) throws IllegalArgumentException {
        if (sse == null) {
            return;
        }
        if (sse.type() != ServerSideEncryption.Type.SSE_C) {
            throw new IllegalArgumentException("only SSE_C is supported for all read requests.");
        }
        if (sse.type().requiresTls() && !this.baseUrl.isHttps()) {
            throw new IllegalArgumentException(sse.type().name() + "operations must be performed over a secure connection.");
        }
    }

    private void checkWriteRequestSse(ServerSideEncryption sse) throws IllegalArgumentException {
        if (sse == null) {
            return;
        }
        if (sse.type().requiresTls() && !this.baseUrl.isHttps()) {
            throw new IllegalArgumentException(sse.type().name() + " operations must be performed over a secure connection.");
        }
    }

    private Map<String, String> normalizeHeaders(Map<String, String> headerMap) {
        HashMap<String, String> normHeaderMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String keyLowerCased = key.toLowerCase(Locale.US);
            if (amzHeaders.contains(keyLowerCased)) {
                key = "x-amz-" + key;
            } else if (!standardHeaders.contains(keyLowerCased) && !keyLowerCased.startsWith("x-amz-")) {
                key = "x-amz-meta-" + key;
            }
            normHeaderMap.put(key, value);
        }
        return normHeaderMap;
    }

    /*
     * WARNING - void declaration
     */
    private HttpUrl buildUrl(Method method, String bucketName, String objectName, String region, Multimap<String, String> queryParamMap) throws IllegalArgumentException, InvalidBucketNameException, NoSuchAlgorithmException {
        if (bucketName == null && objectName != null) {
            throw new InvalidBucketNameException(NULL_STRING, "null bucket name for object '" + objectName + "'");
        }
        HttpUrl.Builder urlBuilder = this.baseUrl.newBuilder();
        if (bucketName != null) {
            this.checkBucketName(bucketName);
            String host = this.baseUrl.host();
            if (host.equals(S3_AMAZONAWS_COM)) {
                void var8_12;
                if (region != null) {
                    host = AwsS3Endpoints.INSTANCE.endpoint(region);
                }
                boolean bl = false;
                if (method == Method.PUT && objectName == null && queryParamMap == null) {
                    boolean bl2 = true;
                } else if (queryParamMap != null && queryParamMap.containsKey("location")) {
                    boolean bl3 = true;
                } else if (bucketName.contains(".") && this.baseUrl.isHttps()) {
                    boolean bl4 = true;
                }
                if (var8_12 != false) {
                    urlBuilder.host(host);
                    urlBuilder.addEncodedPathSegment(S3Escaper.encode(bucketName));
                } else {
                    urlBuilder.host(bucketName + "." + host);
                }
            } else {
                urlBuilder.addEncodedPathSegment(S3Escaper.encode(bucketName));
            }
        }
        if (objectName != null) {
            for (String token : objectName.split("/")) {
                if (!token.equals(".") && !token.equals("..")) continue;
                throw new IllegalArgumentException("object name with '.' or '..' path segment is not supported");
            }
            urlBuilder.addEncodedPathSegments(S3Escaper.encodePath(objectName));
        }
        if (queryParamMap != null) {
            for (Map.Entry entry : queryParamMap.entries()) {
                urlBuilder.addEncodedQueryParameter(S3Escaper.encode((String)entry.getKey()), S3Escaper.encode((String)entry.getValue()));
            }
        }
        return urlBuilder.build();
    }

    private String getHostHeader(HttpUrl url) {
        if (url.scheme().equals("http") && url.port() == 80 || url.scheme().equals("https") && url.port() == 443) {
            return url.host();
        }
        return url.host() + ":" + url.port();
    }

    private Request createRequest(HttpUrl url, Method method, Multimap<String, String> headerMap, Object body, int length) throws IllegalArgumentException, InsufficientDataException, InternalException, IOException, NoSuchAlgorithmException {
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        String contentType = null;
        String contentEncoding = null;
        if (headerMap != null) {
            contentEncoding = headerMap.get("Content-Encoding").stream().distinct().filter(encoding -> !encoding.isEmpty()).collect(Collectors.joining(","));
            for (Map.Entry<String, String> entry : headerMap.entries()) {
                if (entry.getKey().equals("Content-Type")) {
                    contentType = entry.getValue();
                }
                if (entry.getKey().equals("Content-Encoding")) continue;
                requestBuilder.header(entry.getKey(), entry.getValue());
            }
        }
        if (!Strings.isNullOrEmpty(contentEncoding)) {
            requestBuilder.header("Content-Encoding", contentEncoding);
        }
        requestBuilder.header("Host", this.getHostHeader(url));
        requestBuilder.header("Accept-Encoding", "identity");
        requestBuilder.header("User-Agent", this.userAgent);
        String sha256Hash = null;
        String md5Hash = null;
        if (this.accessKey != null && this.secretKey != null) {
            if (url.isHttps()) {
                sha256Hash = "UNSIGNED-PAYLOAD";
                if (body != null) {
                    md5Hash = Digest.md5Hash(body, length);
                }
            } else {
                Object data = body;
                int len = length;
                if (data == null) {
                    data = new byte[0];
                    len = 0;
                }
                String[] hashes = Digest.sha256Md5Hashes(data, len);
                sha256Hash = hashes[0];
                md5Hash = hashes[1];
            }
        } else if (body != null) {
            md5Hash = Digest.md5Hash(body, length);
        }
        if (md5Hash != null) {
            requestBuilder.header("Content-MD5", md5Hash);
        }
        if (sha256Hash != null) {
            requestBuilder.header("x-amz-content-sha256", sha256Hash);
        }
        ZonedDateTime date = ZonedDateTime.now();
        requestBuilder.header("x-amz-date", date.format(Time.AMZ_DATE_FORMAT));
        HttpRequestBody requestBody = null;
        if (body != null) {
            requestBody = body instanceof RandomAccessFile ? new HttpRequestBody((RandomAccessFile)body, length, contentType) : (body instanceof BufferedInputStream ? new HttpRequestBody((BufferedInputStream)body, length, contentType) : new HttpRequestBody((byte[])body, length, contentType));
        }
        requestBuilder.method(method.toString(), requestBody);
        return requestBuilder.build();
    }

    private Response execute(Method method, String bucketName, String objectName, String region, Multimap<String, String> headerMap, Multimap<String, String> queryParamMap, Object body, int length) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        boolean traceRequestBody = false;
        if (!(body == null || body instanceof InputStream || body instanceof RandomAccessFile || body instanceof byte[])) {
            byte[] bytes = body instanceof CharSequence ? body.toString().getBytes(StandardCharsets.UTF_8) : Xml.marshal(body).getBytes(StandardCharsets.UTF_8);
            body = bytes;
            length = bytes.length;
            traceRequestBody = true;
        }
        if (body == null && (method == Method.PUT || method == Method.POST)) {
            body = EMPTY_BODY;
        }
        HttpUrl url = this.buildUrl(method, bucketName, objectName, region, queryParamMap);
        Request request = this.createRequest(url, method, headerMap, body, length);
        if (this.accessKey != null && this.secretKey != null) {
            request = Signer.signV4(request, region, this.accessKey, this.secretKey);
        }
        if (this.traceStream != null) {
            this.traceStream.println("---------START-HTTP---------");
            String encodedPath = request.url().encodedPath();
            String encodedQuery = request.url().encodedQuery();
            if (encodedQuery != null) {
                encodedPath = encodedPath + "?" + encodedQuery;
            }
            this.traceStream.println(request.method() + " " + encodedPath + " HTTP/1.1");
            String headers = request.headers().toString().replaceAll("Signature=([0-9a-f]+)", "Signature=*REDACTED*").replaceAll("Credential=([^/]+)", "Credential=*REDACTED*");
            this.traceStream.println(headers);
            if (traceRequestBody) {
                this.traceStream.println(new String((byte[])body, StandardCharsets.UTF_8));
            }
        }
        Response response = this.httpClient.newCall(request).execute();
        if (this.traceStream != null) {
            this.traceStream.println(response.protocol().toString().toUpperCase(Locale.US) + " " + response.code());
            this.traceStream.println(response.headers());
        }
        if (response.isSuccessful()) {
            if (this.traceStream != null) {
                this.traceStream.println(END_HTTP);
            }
            return response;
        }
        String errorXml = null;
        try (ResponseBody responseBody = response.body();){
            errorXml = new String(responseBody.bytes(), StandardCharsets.UTF_8);
        }
        if (!(this.traceStream == null || "".equals(errorXml) && method.equals((Object)Method.HEAD))) {
            this.traceStream.println(errorXml);
        }
        String contentType = response.headers().get("content-type");
        if (!(method.equals((Object)Method.HEAD) || contentType != null && Arrays.asList(contentType.split(";")).contains("application/xml"))) {
            if (this.traceStream != null) {
                this.traceStream.println(END_HTTP);
            }
            throw new InvalidResponseException();
        }
        ErrorResponse errorResponse = null;
        if (!"".equals(errorXml)) {
            errorResponse = Xml.unmarshal(ErrorResponse.class, errorXml);
        } else if (!method.equals((Object)Method.HEAD)) {
            if (this.traceStream != null) {
                this.traceStream.println(END_HTTP);
            }
            throw new InvalidResponseException();
        }
        if (this.traceStream != null) {
            this.traceStream.println(END_HTTP);
        }
        if (errorResponse == null) {
            ErrorCode ec;
            switch (response.code()) {
                case 307: {
                    ec = ErrorCode.REDIRECT;
                    break;
                }
                case 400: {
                    if (method.equals((Object)Method.HEAD) && bucketName != null && objectName == null && BucketRegionCache.INSTANCE.exists(bucketName)) {
                        ec = ErrorCode.RETRY_HEAD_BUCKET;
                        break;
                    }
                    ec = ErrorCode.INVALID_URI;
                    break;
                }
                case 404: {
                    if (objectName != null) {
                        ec = ErrorCode.NO_SUCH_KEY;
                        break;
                    }
                    if (bucketName != null) {
                        ec = ErrorCode.NO_SUCH_BUCKET;
                        break;
                    }
                    ec = ErrorCode.RESOURCE_NOT_FOUND;
                    break;
                }
                case 405: 
                case 501: {
                    ec = ErrorCode.METHOD_NOT_ALLOWED;
                    break;
                }
                case 409: {
                    if (bucketName != null) {
                        ec = ErrorCode.NO_SUCH_BUCKET;
                        break;
                    }
                    ec = ErrorCode.RESOURCE_CONFLICT;
                    break;
                }
                case 403: {
                    ec = ErrorCode.ACCESS_DENIED;
                    break;
                }
                default: {
                    throw new InternalException("unhandled HTTP code " + response.code() + ".  Please report this issue at https://github.com/minio/minio-java/issues");
                }
            }
            errorResponse = new ErrorResponse(ec, bucketName, objectName, request.url().encodedPath(), response.header("x-amz-request-id"), response.header("x-amz-id-2"));
        }
        if (errorResponse.errorCode() == ErrorCode.NO_SUCH_BUCKET || errorResponse.errorCode() == ErrorCode.RETRY_HEAD_BUCKET) {
            BucketRegionCache.INSTANCE.remove(bucketName);
        }
        throw new ErrorResponseException(errorResponse, response);
    }

    private Response execute(Method method, String bucketName, String objectName, String region, Map<String, String> headerMap, Map<String, String> queryParamMap, Object body, int length) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        SetMultimap<String, String> headerMultiMap = null;
        if (headerMap != null) {
            headerMultiMap = Multimaps.forMap(this.normalizeHeaders(headerMap));
        }
        SetMultimap<String, String> queryParamMultiMap = null;
        if (queryParamMap != null) {
            queryParamMultiMap = Multimaps.forMap(queryParamMap);
        }
        return this.execute(method, bucketName, objectName, region, headerMultiMap, queryParamMultiMap, body, length);
    }

    private void updateRegionCache(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        if (bucketName != null && this.accessKey != null && this.secretKey != null && !BucketRegionCache.INSTANCE.exists(bucketName)) {
            String region;
            HashMap<String, String> queryParamMap = new HashMap<String, String>();
            queryParamMap.put("location", null);
            Response response = this.execute(Method.GET, bucketName, null, US_EAST_1, null, queryParamMap, null, 0);
            try (ResponseBody body = response.body();){
                LocationConstraint lc = Xml.unmarshal(LocationConstraint.class, body.charStream());
                region = lc.location() == null || lc.location().equals("") ? US_EAST_1 : (lc.location().equals("EU") ? "eu-west-1" : lc.location());
            }
            BucketRegionCache.INSTANCE.set(bucketName, region);
        }
    }

    private String getRegion(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        String region;
        if (this.region == null || "".equals(this.region)) {
            this.updateRegionCache(bucketName);
            region = BucketRegionCache.INSTANCE.region(bucketName);
        } else {
            region = this.region;
        }
        return region;
    }

    private Response executeGet(String bucketName, String objectName, Map<String, String> headerMap, Map<String, String> queryParamMap) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        return this.execute(Method.GET, bucketName, objectName, this.getRegion(bucketName), headerMap, queryParamMap, null, 0);
    }

    private Response executeGet(String bucketName, String objectName, Multimap<String, String> queryParamMap) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        return this.execute(Method.GET, bucketName, objectName, this.getRegion(bucketName), null, queryParamMap, null, 0);
    }

    private Response executeHead(String bucketName, String objectName, Map<String, String> headerMap, Map<String, String> queryParamMap) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        Response response = this.execute(Method.HEAD, bucketName, objectName, this.getRegion(bucketName), headerMap, queryParamMap, null, 0);
        response.body().close();
        return response;
    }

    private Response executeHead(String bucketName, String objectName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        try {
            return this.executeHead(bucketName, objectName, null, null);
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().errorCode() != ErrorCode.RETRY_HEAD_BUCKET) {
                throw e;
            }
            return this.executeHead(bucketName, objectName, null, null);
        }
    }

    private Response executeHead(String bucketName, String objectName, Map<String, String> headerMap) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        return this.executeHead(bucketName, objectName, headerMap, null);
    }

    private Response executeDelete(String bucketName, String objectName, Map<String, String> queryParamMap) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        Response response = this.execute(Method.DELETE, bucketName, objectName, this.getRegion(bucketName), null, queryParamMap, null, 0);
        response.body().close();
        return response;
    }

    private Response executePost(String bucketName, String objectName, Map<String, String> headerMap, Map<String, String> queryParamMap, Object data) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        return this.execute(Method.POST, bucketName, objectName, this.getRegion(bucketName), headerMap, queryParamMap, data, 0);
    }

    private Response executePut(String bucketName, String objectName, String region, Map<String, String> headerMap, Map<String, String> queryParamMap, Object data, int length) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        return this.execute(Method.PUT, bucketName, objectName, region, headerMap, queryParamMap, data, length);
    }

    private Response executePut(String bucketName, String objectName, Map<String, String> headerMap, Map<String, String> queryParamMap, Object data, int length) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        return this.executePut(bucketName, objectName, this.getRegion(bucketName), headerMap, queryParamMap, data, length);
    }

    public ObjectStat statObject(String bucketName, String objectName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        return this.statObject(bucketName, objectName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectStat statObject(String bucketName, String objectName, ServerSideEncryption sse) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        this.checkReadRequestSse(sse);
        this.checkBucketName(bucketName);
        this.checkObjectName(objectName);
        Map<String, String> headers = null;
        if (sse != null) {
            headers = sse.headers();
        }
        try (Response response = this.executeHead(bucketName, objectName, headers);){
            ObjectStat objectStat = new ObjectStat(bucketName, objectName, response.headers());
            return objectStat;
        }
    }

    public String getObjectUrl(String bucketName, String objectName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        this.checkObjectName(objectName);
        HttpUrl url = this.buildUrl(Method.GET, bucketName, objectName, this.getRegion(bucketName), null);
        return url.toString();
    }

    public InputStream getObject(String bucketName, String objectName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        return this.getObject(bucketName, objectName, null, null, null);
    }

    public InputStream getObject(String bucketName, String objectName, ServerSideEncryption sse) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        return this.getObject(bucketName, objectName, null, null, sse);
    }

    public InputStream getObject(String bucketName, String objectName, long offset) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        return this.getObject(bucketName, objectName, offset, null, null);
    }

    public InputStream getObject(String bucketName, String objectName, long offset, Long length) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        return this.getObject(bucketName, objectName, offset, length, null);
    }

    public InputStream getObject(String bucketName, String objectName, Long offset, Long length, ServerSideEncryption sse) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        if (bucketName == null || bucketName.isEmpty()) {
            throw new IllegalArgumentException("bucket name cannot be empty");
        }
        this.checkObjectName(objectName);
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("offset should be zero or greater");
        }
        if (length != null && length <= 0L) {
            throw new IllegalArgumentException("length should be greater than zero");
        }
        this.checkReadRequestSse(sse);
        if (length != null && offset == null) {
            offset = 0L;
        }
        HashMap<String, String> headerMap = null;
        if (offset != null || length != null || sse != null) {
            headerMap = new HashMap<String, String>();
        }
        if (length != null) {
            headerMap.put("Range", "bytes=" + offset + "-" + (offset + length - 1L));
        } else if (offset != null) {
            headerMap.put("Range", "bytes=" + offset + "-");
        }
        if (sse != null) {
            headerMap.putAll(sse.headers());
        }
        Response response = this.executeGet(bucketName, objectName, headerMap, null);
        return response.body().byteStream();
    }

    public void getObject(String bucketName, String objectName, String fileName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        this.getObject(bucketName, objectName, null, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getObject(String bucketName, String objectName, ServerSideEncryption sse, String fileName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        this.checkReadRequestSse(sse);
        Path filePath = Paths.get(fileName, new String[0]);
        boolean fileExists = Files.exists(filePath, new LinkOption[0]);
        if (fileExists && !Files.isRegularFile(filePath, new LinkOption[0])) {
            throw new IllegalArgumentException(fileName + ": not a regular file");
        }
        ObjectStat objectStat = this.statObject(bucketName, objectName, sse);
        long length = objectStat.length();
        String etag = objectStat.etag();
        String tempFileName = fileName + "." + etag + ".part.minio";
        Path tempFilePath = Paths.get(tempFileName, new String[0]);
        boolean tempFileExists = Files.exists(tempFilePath, new LinkOption[0]);
        if (tempFileExists && !Files.isRegularFile(tempFilePath, new LinkOption[0])) {
            throw new IOException(tempFileName + ": not a regular file");
        }
        long tempFileSize = 0L;
        if (tempFileExists && (tempFileSize = Files.size(tempFilePath)) > length) {
            Files.delete(tempFilePath);
            tempFileExists = false;
            tempFileSize = 0L;
        }
        if (fileExists) {
            long fileSize = Files.size(filePath);
            if (fileSize == length) {
                return;
            }
            if (fileSize > length) {
                throw new IllegalArgumentException("Source object, '" + objectName + "', size:" + length + " is smaller than the destination file, '" + fileName + "', size:" + fileSize);
            }
            if (!tempFileExists) {
                Files.copy(filePath, tempFilePath, new CopyOption[0]);
                tempFileSize = fileSize;
                tempFileExists = true;
            }
        }
        InputStream is = null;
        OutputStream os = null;
        try {
            is = this.getObject(bucketName, objectName, tempFileSize, null, sse);
            os = Files.newOutputStream(tempFilePath, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            long bytesWritten = ByteStreams.copy(is, os);
            is.close();
            os.close();
            if (bytesWritten != length - tempFileSize) {
                throw new IOException(tempFileName + ": unexpected data written.  expected = " + (length - tempFileSize) + ", written = " + bytesWritten);
            }
            Files.move(tempFilePath, filePath, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public void copyObject(String bucketName, String objectName, Map<String, String> headerMap, ServerSideEncryption sse, String srcBucketName, String srcObjectName, ServerSideEncryption srcSse, CopyConditions copyConditions) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        if (bucketName == null || bucketName.isEmpty()) {
            throw new IllegalArgumentException("bucket name cannot be empty");
        }
        this.checkObjectName(objectName);
        this.checkWriteRequestSse(sse);
        if (srcBucketName == null || srcBucketName.isEmpty()) {
            throw new IllegalArgumentException("Source bucket name cannot be empty");
        }
        if (srcObjectName == null) {
            srcObjectName = objectName;
        }
        this.checkReadRequestSse(srcSse);
        if (headerMap == null) {
            headerMap = new HashMap<String, String>();
        }
        headerMap.put("x-amz-copy-source", S3Escaper.encodePath(srcBucketName + "/" + srcObjectName));
        if (sse != null) {
            headerMap.putAll(sse.headers());
        }
        if (srcSse != null) {
            headerMap.putAll(srcSse.copySourceHeaders());
        }
        if (copyConditions != null) {
            headerMap.putAll(copyConditions.getConditions());
        }
        Response response = this.executePut(bucketName, objectName, headerMap, null, "", 0);
        try (ResponseBody body = response.body();){
            Xml.unmarshal(CopyObjectResult.class, body.charStream());
        }
    }

    public void composeObject(String bucketName, String objectName, List<ComposeSource> sources, Map<String, String> headerMap, ServerSideEncryption sse) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        if (bucketName == null || bucketName.isEmpty()) {
            throw new IllegalArgumentException("bucket name cannot be empty");
        }
        this.checkObjectName(objectName);
        if (sources.isEmpty()) {
            throw new IllegalArgumentException("compose sources cannot be empty");
        }
        this.checkWriteRequestSse(sse);
        long objectSize = 0L;
        int partsCount = 0;
        for (int i = 0; i < sources.size(); ++i) {
            ComposeSource src = sources.get(i);
            this.checkReadRequestSse(src.sse());
            ObjectStat stat = this.statObject(src.bucketName(), src.objectName(), src.sse());
            src.buildHeaders(stat.length(), stat.etag());
            if (i != 0 && src.headers().containsKey("x-amz-meta-x-amz-key")) {
                throw new IllegalArgumentException("Client side encryption is not supported for more than one source");
            }
            long size = stat.length();
            if (src.length() != null) {
                size = src.length();
            } else if (src.offset() != null) {
                size -= src.offset().longValue();
            }
            if (size < 0x500000L && sources.size() != 1 && i != sources.size() - 1) {
                throw new IllegalArgumentException("source " + src.bucketName() + "/" + src.objectName() + ": size " + size + " must be greater than " + 0x500000);
            }
            if ((objectSize += size) > 0x50000000000L) {
                throw new IllegalArgumentException("Destination object size must be less than 5497558138880");
            }
            if (size > 0x140000000L) {
                long count = size / 0x140000000L;
                long lastPartSize = size - count * 0x140000000L;
                if (lastPartSize > 0L) {
                    ++count;
                } else {
                    lastPartSize = 0x140000000L;
                }
                if (lastPartSize < 0x500000L && sources.size() != 1 && i != sources.size() - 1) {
                    throw new IllegalArgumentException("source " + src.bucketName() + "/" + src.objectName() + ": for multipart split upload of " + size + ", last part size is less than " + 0x500000);
                }
                partsCount += (int)count;
            } else {
                ++partsCount;
            }
            if (partsCount <= 10000) continue;
            throw new IllegalArgumentException("Compose sources create more than allowed multipart count 10000");
        }
        if (partsCount == 1) {
            ComposeSource src = sources.get(0);
            if (headerMap == null) {
                headerMap = new HashMap<String, String>();
            }
            if (src.offset() != null && src.length() == null) {
                headerMap.put("x-amz-copy-source-range", "bytes=" + src.offset() + "-");
            }
            if (src.offset() != null && src.length() != null) {
                headerMap.put("x-amz-copy-source-range", "bytes=" + src.offset() + "-" + (src.offset() + src.length() - 1L));
            }
            this.copyObject(bucketName, objectName, headerMap, sse, src.bucketName(), src.objectName(), src.sse(), src.copyConditions());
            return;
        }
        Map<String, String> sseHeaders = null;
        if (sse != null) {
            sseHeaders = sse.headers();
            if (headerMap == null) {
                headerMap = new HashMap<String, String>();
            }
            headerMap.putAll(sseHeaders);
        }
        String uploadId = this.createMultipartUpload(bucketName, objectName, headerMap);
        int partNumber = 0;
        Part[] totalParts = new Part[partsCount];
        try {
            for (int i = 0; i < sources.size(); ++i) {
                ComposeSource src = sources.get(i);
                long size = src.objectSize();
                if (src.length() != null) {
                    size = src.length();
                } else if (src.offset() != null) {
                    size -= src.offset().longValue();
                }
                long offset = 0L;
                if (src.offset() != null) {
                    offset = src.offset();
                }
                if (size <= 0x140000000L) {
                    ++partNumber;
                    HashMap<String, String> headers = new HashMap<String, String>();
                    if (src.headers() != null) {
                        headers.putAll(src.headers());
                    }
                    if (src.length() != null) {
                        headers.put("x-amz-copy-source-range", "bytes=" + offset + "-" + (offset + src.length() - 1L));
                    } else if (src.offset() != null) {
                        headers.put("x-amz-copy-source-range", "bytes=" + offset + "-" + (offset + size - 1L));
                    }
                    if (sseHeaders != null) {
                        headers.putAll(sseHeaders);
                    }
                    String eTag = this.uploadPartCopy(bucketName, objectName, uploadId, partNumber, headers);
                    totalParts[partNumber - 1] = new Part(partNumber, eTag);
                    continue;
                }
                while (size > 0L) {
                    ++partNumber;
                    long startBytes = offset;
                    long endBytes = startBytes + 0x140000000L;
                    if (size < 0x140000000L) {
                        endBytes = startBytes + size;
                    }
                    Map<String, String> headers = src.headers();
                    headers.put("x-amz-copy-source-range", "bytes=" + startBytes + "-" + endBytes);
                    if (sseHeaders != null) {
                        headers.putAll(sseHeaders);
                    }
                    String eTag = this.uploadPartCopy(bucketName, objectName, uploadId, partNumber, headers);
                    totalParts[partNumber - 1] = new Part(partNumber, eTag);
                    offset = startBytes;
                    size -= endBytes - startBytes;
                }
            }
            this.completeMultipartUpload(bucketName, objectName, uploadId, totalParts);
        }
        catch (RuntimeException e) {
            this.abortMultipartUpload(bucketName, objectName, uploadId);
            throw e;
        }
        catch (Exception e) {
            this.abortMultipartUpload(bucketName, objectName, uploadId);
            throw e;
        }
    }

    public String getPresignedObjectUrl(Method method, String bucketName, String objectName, Integer expires, Map<String, String> reqParams) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidExpiresRangeException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        if (expires < 1 || expires > 604800) {
            throw new InvalidExpiresRangeException(expires, "expires must be in range of 1 to 604800");
        }
        byte[] body = null;
        if (method == Method.PUT || method == Method.POST) {
            body = new byte[]{};
        }
        HashMultimap<String, String> queryParamMap = null;
        if (reqParams != null) {
            queryParamMap = HashMultimap.create();
            for (Map.Entry<String, String> m3 : reqParams.entrySet()) {
                queryParamMap.put(m3.getKey(), m3.getValue());
            }
        }
        String region = this.getRegion(bucketName);
        HttpUrl url = this.buildUrl(method, bucketName, objectName, region, queryParamMap);
        Request request = this.createRequest(url, method, null, body, 0);
        url = Signer.presignV4(request, region, this.accessKey, this.secretKey, expires);
        return url.toString();
    }

    public String presignedGetObject(String bucketName, String objectName, Integer expires, Map<String, String> reqParams) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidExpiresRangeException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        return this.getPresignedObjectUrl(Method.GET, bucketName, objectName, expires, reqParams);
    }

    public String presignedGetObject(String bucketName, String objectName, Integer expires) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidExpiresRangeException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        return this.presignedGetObject(bucketName, objectName, expires, null);
    }

    public String presignedGetObject(String bucketName, String objectName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidExpiresRangeException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        return this.presignedGetObject(bucketName, objectName, 604800, null);
    }

    public String presignedPutObject(String bucketName, String objectName, Integer expires) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidExpiresRangeException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        return this.getPresignedObjectUrl(Method.PUT, bucketName, objectName, expires, null);
    }

    public String presignedPutObject(String bucketName, String objectName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidExpiresRangeException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        return this.presignedPutObject(bucketName, objectName, 604800);
    }

    public Map<String, String> presignedPostPolicy(PostPolicy policy) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidExpiresRangeException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        return policy.formData(this.accessKey, this.secretKey, this.getRegion(policy.bucketName()));
    }

    public void removeObject(String bucketName, String objectName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        if (bucketName == null || bucketName.isEmpty()) {
            throw new IllegalArgumentException("bucket name cannot be empty");
        }
        this.checkObjectName(objectName);
        this.executeDelete(bucketName, objectName, null);
    }

    public Iterable<Result<DeleteError>> removeObjects(final String bucketName, final Iterable<String> objectNames) {
        return new Iterable<Result<DeleteError>>(){

            @Override
            public Iterator<Result<DeleteError>> iterator() {
                return new Iterator<Result<DeleteError>>(){
                    private Result<DeleteError> error;
                    private Iterator<DeleteError> errorIterator;
                    private boolean completed = false;
                    private Iterator<String> objectNameIter;
                    {
                        this.objectNameIter = objectNames.iterator();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private synchronized void populate() {
                        List<DeleteError> errorList = null;
                        try {
                            int i;
                            LinkedList<DeleteObject> objectList = new LinkedList<DeleteObject>();
                            for (i = 0; this.objectNameIter.hasNext() && i < 1000; ++i) {
                                objectList.add(new DeleteObject(this.objectNameIter.next()));
                            }
                            if (i > 0) {
                                DeleteResult result = MinioClient.this.deleteObjects(bucketName, objectList, true);
                                errorList = result.errorList();
                            }
                        }
                        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | InvalidResponseException | XmlParserException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException e) {
                            this.error = new Result(e);
                        }
                        finally {
                            this.errorIterator = errorList != null ? errorList.iterator() : new LinkedList().iterator();
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.completed) {
                            return false;
                        }
                        if (this.error == null && this.errorIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && this.errorIterator != null && !this.errorIterator.hasNext()) {
                            this.populate();
                        }
                        if (this.error != null) {
                            return true;
                        }
                        if (this.errorIterator.hasNext()) {
                            return true;
                        }
                        this.completed = true;
                        return false;
                    }

                    @Override
                    public Result<DeleteError> next() {
                        if (this.completed) {
                            throw new NoSuchElementException();
                        }
                        if (this.error == null && this.errorIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && this.errorIterator != null && !this.errorIterator.hasNext()) {
                            this.populate();
                        }
                        if (this.error != null) {
                            this.completed = true;
                            return this.error;
                        }
                        if (this.errorIterator.hasNext()) {
                            return new Result<DeleteError>(this.errorIterator.next());
                        }
                        this.completed = true;
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Iterable<Result<Item>> listObjects(String bucketName) throws XmlParserException {
        return this.listObjects(bucketName, null);
    }

    public Iterable<Result<Item>> listObjects(String bucketName, String prefix) throws XmlParserException {
        return this.listObjects(bucketName, prefix, true);
    }

    public Iterable<Result<Item>> listObjects(String bucketName, String prefix, boolean recursive) {
        return this.listObjects(bucketName, prefix, recursive, false);
    }

    public Iterable<Result<Item>> listObjects(String bucketName, String prefix, boolean recursive, boolean useVersion1) {
        return this.listObjects(bucketName, prefix, recursive, false, false);
    }

    public Iterable<Result<Item>> listObjects(String bucketName, String prefix, boolean recursive, boolean includeUserMetadata, boolean useVersion1) {
        if (useVersion1) {
            if (includeUserMetadata) {
                throw new IllegalArgumentException("include user metadata flag is not supported in version 1");
            }
            return this.listObjectsV1(bucketName, prefix, recursive);
        }
        return this.listObjectsV2(bucketName, prefix, recursive, includeUserMetadata);
    }

    private Iterable<Result<Item>> listObjectsV2(final String bucketName, final String prefix, final boolean recursive, final boolean includeUserMetadata) {
        return new Iterable<Result<Item>>(){

            @Override
            public Iterator<Result<Item>> iterator() {
                return new Iterator<Result<Item>>(){
                    private ListBucketResult listBucketResult;
                    private Result<Item> error;
                    private Iterator<Item> itemIterator;
                    private Iterator<Prefix> prefixIterator;
                    private boolean completed = false;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private synchronized void populate() {
                        String delimiter = "/";
                        if (recursive) {
                            delimiter = null;
                        }
                        String continuationToken = null;
                        if (this.listBucketResult != null) {
                            continuationToken = this.listBucketResult.nextContinuationToken();
                        }
                        this.listBucketResult = null;
                        this.itemIterator = null;
                        this.prefixIterator = null;
                        try {
                            this.listBucketResult = MinioClient.this.listObjectsV2(bucketName, continuationToken, delimiter, false, null, prefix, null, includeUserMetadata);
                        }
                        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | InvalidResponseException | XmlParserException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException e) {
                            this.error = new Result(e);
                        }
                        finally {
                            if (this.listBucketResult != null) {
                                this.itemIterator = this.listBucketResult.contents().iterator();
                                this.prefixIterator = this.listBucketResult.commonPrefixes().iterator();
                            } else {
                                this.itemIterator = new LinkedList().iterator();
                                this.prefixIterator = new LinkedList().iterator();
                            }
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.completed) {
                            return false;
                        }
                        if (this.error == null && this.itemIterator == null && this.prefixIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.itemIterator.hasNext() && !this.prefixIterator.hasNext() && this.listBucketResult.isTruncated()) {
                            this.populate();
                        }
                        if (this.error != null) {
                            return true;
                        }
                        if (this.itemIterator.hasNext()) {
                            return true;
                        }
                        if (this.prefixIterator.hasNext()) {
                            return true;
                        }
                        this.completed = true;
                        return false;
                    }

                    @Override
                    public Result<Item> next() {
                        if (this.completed) {
                            throw new NoSuchElementException();
                        }
                        if (this.error == null && this.itemIterator == null && this.prefixIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.itemIterator.hasNext() && !this.prefixIterator.hasNext() && this.listBucketResult.isTruncated()) {
                            this.populate();
                        }
                        if (this.error != null) {
                            this.completed = true;
                            return this.error;
                        }
                        if (this.itemIterator.hasNext()) {
                            Item item = this.itemIterator.next();
                            return new Result<Item>(item);
                        }
                        if (this.prefixIterator.hasNext()) {
                            return new Result<Item>(this.prefixIterator.next().toItem());
                        }
                        this.completed = true;
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private Iterable<Result<Item>> listObjectsV1(final String bucketName, final String prefix, final boolean recursive) {
        return new Iterable<Result<Item>>(){

            @Override
            public Iterator<Result<Item>> iterator() {
                return new Iterator<Result<Item>>(){
                    private String lastObjectName;
                    private ListBucketResultV1 listBucketResult;
                    private Result<Item> error;
                    private Iterator<Item> itemIterator;
                    private Iterator<Prefix> prefixIterator;
                    private boolean completed = false;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private synchronized void populate() {
                        String delimiter = "/";
                        if (recursive) {
                            delimiter = null;
                        }
                        String marker = null;
                        if (this.listBucketResult != null) {
                            marker = delimiter != null ? this.listBucketResult.nextMarker() : this.lastObjectName;
                        }
                        this.listBucketResult = null;
                        this.itemIterator = null;
                        this.prefixIterator = null;
                        try {
                            this.listBucketResult = MinioClient.this.listObjectsV1(bucketName, delimiter, marker, null, prefix);
                        }
                        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | InvalidResponseException | XmlParserException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException e) {
                            this.error = new Result(e);
                        }
                        finally {
                            if (this.listBucketResult != null) {
                                this.itemIterator = this.listBucketResult.contents().iterator();
                                this.prefixIterator = this.listBucketResult.commonPrefixes().iterator();
                            } else {
                                this.itemIterator = new LinkedList().iterator();
                                this.prefixIterator = new LinkedList().iterator();
                            }
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.completed) {
                            return false;
                        }
                        if (this.error == null && this.itemIterator == null && this.prefixIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.itemIterator.hasNext() && !this.prefixIterator.hasNext() && this.listBucketResult.isTruncated()) {
                            this.populate();
                        }
                        if (this.error != null) {
                            return true;
                        }
                        if (this.itemIterator.hasNext()) {
                            return true;
                        }
                        if (this.prefixIterator.hasNext()) {
                            return true;
                        }
                        this.completed = true;
                        return false;
                    }

                    @Override
                    public Result<Item> next() {
                        if (this.completed) {
                            throw new NoSuchElementException();
                        }
                        if (this.error == null && this.itemIterator == null && this.prefixIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.itemIterator.hasNext() && !this.prefixIterator.hasNext() && this.listBucketResult.isTruncated()) {
                            this.populate();
                        }
                        if (this.error != null) {
                            this.completed = true;
                            return this.error;
                        }
                        if (this.itemIterator.hasNext()) {
                            Item item = this.itemIterator.next();
                            this.lastObjectName = item.objectName();
                            return new Result<Item>(item);
                        }
                        if (this.prefixIterator.hasNext()) {
                            return new Result<Item>(this.prefixIterator.next().toItem());
                        }
                        this.completed = true;
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public List<Bucket> listBuckets() throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        Response response = this.executeGet(null, null, null);
        try (ResponseBody body = response.body();){
            ListAllMyBucketsResult result = Xml.unmarshal(ListAllMyBucketsResult.class, body.charStream());
            List<Bucket> list = result.buckets();
            return list;
        }
    }

    public boolean bucketExists(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        try {
            this.executeHead(bucketName, null);
            return true;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().errorCode() != ErrorCode.NO_SUCH_BUCKET) {
                throw e;
            }
            return false;
        }
    }

    public void makeBucket(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, RegionConflictException, XmlParserException {
        this.makeBucket(bucketName, null, false);
    }

    public void makeBucket(String bucketName, String region) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, RegionConflictException, XmlParserException {
        this.makeBucket(bucketName, region, false);
    }

    public void makeBucket(String bucketName, String region, boolean objectLock) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, RegionConflictException, XmlParserException {
        if (region == null) {
            region = this.region;
        }
        if (this.region != null && !this.region.equals(region)) {
            throw new RegionConflictException("passed region conflicts with the one previously specified");
        }
        if (region == null) {
            region = US_EAST_1;
        }
        CreateBucketConfiguration config = null;
        if (!region.equals(US_EAST_1)) {
            config = new CreateBucketConfiguration(region);
        }
        HashMap<String, String> headerMap = null;
        if (objectLock) {
            headerMap = new HashMap<String, String>();
            headerMap.put("x-amz-bucket-object-lock-enabled", "true");
        }
        Response response = this.executePut(bucketName, null, region, headerMap, null, config, 0);
        response.body().close();
    }

    public void enableVersioning(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("versioning", "");
        String config = "<VersioningConfiguration xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><Status>Enabled</Status></VersioningConfiguration>";
        Response response = this.executePut(bucketName, null, null, queryParamMap, config, 0);
        response.body().close();
    }

    public void disableVersioning(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("versioning", "");
        String config = "<VersioningConfiguration xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><Status>Suspended</Status></VersioningConfiguration>";
        Response response = this.executePut(bucketName, null, null, queryParamMap, config, 0);
        response.body().close();
    }

    public void setDefaultRetention(String bucketName, ObjectLockConfiguration config) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("object-lock", "");
        Response response = this.executePut(bucketName, null, null, queryParamMap, config, 0);
        response.body().close();
    }

    public ObjectLockConfiguration getDefaultRetention(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("object-lock", "");
        Response response = this.executeGet(bucketName, null, null, queryParamMap);
        try (ResponseBody body = response.body();){
            ObjectLockConfiguration objectLockConfiguration = Xml.unmarshal(ObjectLockConfiguration.class, body.charStream());
            return objectLockConfiguration;
        }
    }

    public void setObjectRetention(String bucketName, String objectName, String versionId, Retention config, boolean bypassGovernanceRetention) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        if (config == null) {
            throw new IllegalArgumentException("null value is not allowed in config.");
        }
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("retention", "");
        if (versionId != null && !versionId.isEmpty()) {
            queryParamMap.put("versionId", versionId);
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (bypassGovernanceRetention) {
            headerMap.put("x-amz-bypass-governance-retention", "True");
        }
        Response response = this.executePut(bucketName, objectName, headerMap, queryParamMap, config, 0);
        response.body().close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Retention getObjectRetention(String bucketName, String objectName, String versionId) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("retention", "");
        if (versionId != null && !versionId.isEmpty()) {
            queryParamMap.put("versionId", versionId);
        }
        try (Response response = this.executeGet(bucketName, objectName, null, queryParamMap);){
            Retention retention2;
            Retention retention = retention2 = Xml.unmarshal(Retention.class, response.body().charStream());
            return retention;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().errorCode() == ErrorCode.NO_SUCH_OBJECT_LOCK_CONFIGURATION) return null;
            throw e;
        }
    }

    public void enableObjectLegalHold(String bucketName, String objectName, String versionId) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("legal-hold", "");
        if (versionId != null && !versionId.isEmpty()) {
            queryParamMap.put("versionId", versionId);
        }
        LegalHold legalHold = new LegalHold(true);
        Response response = this.executePut(bucketName, objectName, null, queryParamMap, legalHold, 0);
        response.body().close();
    }

    public void disableObjectLegalHold(String bucketName, String objectName, String versionId) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("legal-hold", "");
        if (versionId != null && !versionId.isEmpty()) {
            queryParamMap.put("versionId", versionId);
        }
        LegalHold legalHold = new LegalHold(false);
        Response response = this.executePut(bucketName, objectName, null, queryParamMap, legalHold, 0);
        response.body().close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isObjectLegalHoldEnabled(String bucketName, String objectName, String versionId) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("legal-hold", "");
        if (versionId != null && !versionId.isEmpty()) {
            queryParamMap.put("versionId", versionId);
        }
        try (Response response = this.executeGet(bucketName, objectName, null, queryParamMap);){
            LegalHold result = Xml.unmarshal(LegalHold.class, response.body().charStream());
            boolean bl = result.status();
            return bl;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().errorCode() == ErrorCode.NO_SUCH_OBJECT_LOCK_CONFIGURATION) return false;
            throw e;
        }
    }

    public void removeBucket(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        this.executeDelete(bucketName, null, null);
    }

    private void putObject(String bucketName, String objectName, PutObjectOptions options, Object data) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (options.headers() != null) {
            headerMap.putAll(options.headers());
        }
        if (options.sse() != null) {
            this.checkWriteRequestSse(options.sse());
            headerMap.putAll(options.sse().headers());
        }
        headerMap.put("Content-Type", options.contentType());
        String uploadId = this.createMultipartUpload(bucketName, objectName, headerMap);
        long uploadedSize = 0L;
        int partCount = options.partCount();
        Part[] totalParts = new Part[10000];
        try {
            for (int partNumber = 1; partNumber <= partCount || partCount < 0; ++partNumber) {
                long availableSize = options.partSize();
                if (partCount > 0) {
                    if (partNumber == partCount) {
                        availableSize = options.objectSize() - uploadedSize;
                    }
                } else {
                    availableSize = this.getAvailableSize(data, options.partSize() + 1L);
                    if (availableSize <= options.partSize()) {
                        partCount = partNumber;
                    } else {
                        availableSize = options.partSize();
                    }
                }
                Map<String, String> ssecHeaders = null;
                if (options.sse() != null && options.sse().type() == ServerSideEncryption.Type.SSE_C) {
                    ssecHeaders = options.sse().headers();
                }
                String etag = this.uploadPart(bucketName, objectName, data, (int)availableSize, uploadId, partNumber, ssecHeaders);
                totalParts[partNumber - 1] = new Part(partNumber, etag);
                uploadedSize += availableSize;
            }
            this.completeMultipartUpload(bucketName, objectName, uploadId, totalParts);
        }
        catch (RuntimeException e) {
            this.abortMultipartUpload(bucketName, objectName, uploadId);
            throw e;
        }
        catch (Exception e) {
            this.abortMultipartUpload(bucketName, objectName, uploadId);
            throw e;
        }
    }

    public void putObject(String bucketName, String objectName, String filename, PutObjectOptions options) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        String contentType;
        this.checkBucketName(bucketName);
        this.checkObjectName(objectName);
        if (filename == null || "".equals(filename)) {
            throw new IllegalArgumentException("empty filename is not allowed");
        }
        Path filePath = Paths.get(filename, new String[0]);
        if (!Files.isRegularFile(filePath, new LinkOption[0])) {
            throw new IllegalArgumentException(filename + " not a regular file");
        }
        long fileSize = Files.size(filePath);
        if (options == null) {
            options = new PutObjectOptions(fileSize, -1L);
        } else if (options.objectSize() != fileSize) {
            throw new IllegalArgumentException("file size " + fileSize + " and object size in options " + options.objectSize() + " do not match");
        }
        if (options.contentType().equals("application/octet-stream") && (contentType = Files.probeContentType(filePath)) != null && !contentType.equals("")) {
            options.setContentType(contentType);
        }
        try (RandomAccessFile file = new RandomAccessFile(filePath.toFile(), "r");){
            this.putObject(bucketName, objectName, options, file);
        }
    }

    public void putObject(String bucketName, String objectName, InputStream stream, PutObjectOptions options) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        this.checkBucketName(bucketName);
        this.checkObjectName(objectName);
        if (stream == null) {
            throw new IllegalArgumentException("InputStream must be provided");
        }
        if (options == null) {
            throw new IllegalArgumentException("PutObjectOptions must be provided");
        }
        if (!(stream instanceof BufferedInputStream)) {
            stream = new BufferedInputStream(stream);
        }
        this.putObject(bucketName, objectName, options, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBucketPolicy(String bucketName) throws BucketPolicyTooLargeException, ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("policy", "");
        Response response = null;
        byte[] buf = new byte[12288];
        int bytesRead = 0;
        try {
            response = this.executeGet(bucketName, null, null, queryParamMap);
            bytesRead = response.body().byteStream().read(buf, 0, 12288);
            if (bytesRead < 0) {
                throw new IOException("unexpected EOF when reading bucket policy");
            }
            if (bytesRead == 12288) {
                int byteRead = 0;
                while (byteRead == 0) {
                    byteRead = response.body().byteStream().read();
                    if (byteRead < 0) {
                        break;
                    }
                    if (byteRead <= 0) continue;
                    throw new BucketPolicyTooLargeException(bucketName);
                }
            }
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().errorCode() != ErrorCode.NO_SUCH_BUCKET_POLICY) {
                throw e;
            }
        }
        finally {
            if (response != null) {
                response.body().close();
            }
        }
        return new String(buf, 0, bytesRead, StandardCharsets.UTF_8);
    }

    public void setBucketPolicy(String bucketName, String policy) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json");
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("policy", "");
        Response response = this.executePut(bucketName, null, headerMap, queryParamMap, policy, 0);
        response.body().close();
    }

    public void setBucketLifeCycle(String bucketName, String lifeCycle) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        if (lifeCycle == null || "".equals(lifeCycle)) {
            throw new IllegalArgumentException("life cycle cannot be empty");
        }
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("lifecycle", "");
        Response response = this.executePut(bucketName, null, null, queryParamMap, lifeCycle, 0);
        response.body().close();
    }

    public void deleteBucketLifeCycle(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("lifecycle", "");
        Response response = this.executeDelete(bucketName, "", queryParamMap);
        response.body().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBucketLifeCycle(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("lifecycle", "");
        String bodyContent = "";
        Response response = null;
        try {
            response = this.executeGet(bucketName, null, null, queryParamMap);
            bodyContent = new String(response.body().bytes(), StandardCharsets.UTF_8);
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().errorCode() != ErrorCode.NO_SUCH_LIFECYCLE_CONFIGURATION) {
                throw e;
            }
        }
        finally {
            if (response != null) {
                response.body().close();
            }
        }
        return bodyContent;
    }

    public NotificationConfiguration getBucketNotification(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("notification", "");
        Response response = this.executeGet(bucketName, null, null, queryParamMap);
        try (ResponseBody body = response.body();){
            NotificationConfiguration notificationConfiguration = Xml.unmarshal(NotificationConfiguration.class, body.charStream());
            return notificationConfiguration;
        }
    }

    public void setBucketNotification(String bucketName, NotificationConfiguration notificationConfiguration) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("notification", "");
        Response response = this.executePut(bucketName, null, null, queryParamMap, notificationConfiguration, 0);
        response.body().close();
    }

    public void removeAllBucketNotification(String bucketName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        NotificationConfiguration notificationConfiguration = new NotificationConfiguration();
        this.setBucketNotification(bucketName, notificationConfiguration);
    }

    public Iterable<Result<Upload>> listIncompleteUploads(String bucketName) throws XmlParserException {
        return this.listIncompleteUploads(bucketName, null, true, true);
    }

    public Iterable<Result<Upload>> listIncompleteUploads(String bucketName, String prefix) throws XmlParserException {
        return this.listIncompleteUploads(bucketName, prefix, true, true);
    }

    public Iterable<Result<Upload>> listIncompleteUploads(String bucketName, String prefix, boolean recursive) {
        return this.listIncompleteUploads(bucketName, prefix, recursive, true);
    }

    private Iterable<Result<Upload>> listIncompleteUploads(final String bucketName, final String prefix, final boolean recursive, final boolean aggregatePartSize) {
        return new Iterable<Result<Upload>>(){

            @Override
            public Iterator<Result<Upload>> iterator() {
                return new Iterator<Result<Upload>>(){
                    private String nextKeyMarker;
                    private String nextUploadIdMarker;
                    private ListMultipartUploadsResult listMultipartUploadsResult;
                    private Result<Upload> error;
                    private Iterator<Upload> uploadIterator;
                    private boolean completed = false;

                    private synchronized void populate() {
                        String delimiter = "/";
                        if (recursive) {
                            delimiter = null;
                        }
                        this.listMultipartUploadsResult = null;
                        this.uploadIterator = null;
                        try {
                            this.listMultipartUploadsResult = MinioClient.this.listMultipartUploads(bucketName, delimiter, this.nextKeyMarker, null, prefix, this.nextUploadIdMarker);
                        }
                        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | InvalidResponseException | XmlParserException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException e) {
                            this.error = new Result(e);
                        }
                        finally {
                            this.uploadIterator = this.listMultipartUploadsResult != null ? this.listMultipartUploadsResult.uploads().iterator() : new LinkedList().iterator();
                        }
                    }

                    private synchronized long getAggregatedPartSize(String objectName, String uploadId) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
                        long aggregatedPartSize = 0L;
                        for (Result result : MinioClient.this.listObjectParts(bucketName, objectName, uploadId)) {
                            aggregatedPartSize += ((Part)result.get()).partSize();
                        }
                        return aggregatedPartSize;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.completed) {
                            return false;
                        }
                        if (this.error == null && this.uploadIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.uploadIterator.hasNext() && this.listMultipartUploadsResult.isTruncated()) {
                            this.nextKeyMarker = this.listMultipartUploadsResult.nextKeyMarker();
                            this.nextUploadIdMarker = this.listMultipartUploadsResult.nextUploadIdMarker();
                            this.populate();
                        }
                        if (this.error != null) {
                            return true;
                        }
                        if (this.uploadIterator.hasNext()) {
                            return true;
                        }
                        this.completed = true;
                        return false;
                    }

                    @Override
                    public Result<Upload> next() {
                        if (this.completed) {
                            throw new NoSuchElementException();
                        }
                        if (this.error == null && this.uploadIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.uploadIterator.hasNext() && this.listMultipartUploadsResult.isTruncated()) {
                            this.nextKeyMarker = this.listMultipartUploadsResult.nextKeyMarker();
                            this.nextUploadIdMarker = this.listMultipartUploadsResult.nextUploadIdMarker();
                            this.populate();
                        }
                        if (this.error != null) {
                            this.completed = true;
                            return this.error;
                        }
                        if (this.uploadIterator.hasNext()) {
                            Upload upload = this.uploadIterator.next();
                            if (aggregatePartSize) {
                                long aggregatedPartSize;
                                try {
                                    aggregatedPartSize = this.getAggregatedPartSize(upload.objectName(), upload.uploadId());
                                }
                                catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | InvalidResponseException | XmlParserException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException e) {
                                    aggregatedPartSize = -1L;
                                }
                                upload.setAggregatedPartSize(aggregatedPartSize);
                            }
                            return new Result<Upload>(upload);
                        }
                        this.completed = true;
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private Iterable<Result<Part>> listObjectParts(final String bucketName, final String objectName, final String uploadId) {
        return new Iterable<Result<Part>>(){

            @Override
            public Iterator<Result<Part>> iterator() {
                return new Iterator<Result<Part>>(){
                    private int nextPartNumberMarker;
                    private ListPartsResult listPartsResult;
                    private Result<Part> error;
                    private Iterator<Part> partIterator;
                    private boolean completed = false;

                    private synchronized void populate() {
                        this.listPartsResult = null;
                        this.partIterator = null;
                        try {
                            this.listPartsResult = MinioClient.this.listParts(bucketName, objectName, null, this.nextPartNumberMarker, uploadId);
                        }
                        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | InvalidResponseException | XmlParserException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException e) {
                            this.error = new Result(e);
                        }
                        finally {
                            this.partIterator = this.listPartsResult != null ? this.listPartsResult.partList().iterator() : new LinkedList().iterator();
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.completed) {
                            return false;
                        }
                        if (this.error == null && this.partIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.partIterator.hasNext() && this.listPartsResult.isTruncated()) {
                            this.nextPartNumberMarker = this.listPartsResult.nextPartNumberMarker();
                            this.populate();
                        }
                        if (this.error != null) {
                            return true;
                        }
                        if (this.partIterator.hasNext()) {
                            return true;
                        }
                        this.completed = true;
                        return false;
                    }

                    @Override
                    public Result<Part> next() {
                        if (this.completed) {
                            throw new NoSuchElementException();
                        }
                        if (this.error == null && this.partIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.partIterator.hasNext() && this.listPartsResult.isTruncated()) {
                            this.nextPartNumberMarker = this.listPartsResult.nextPartNumberMarker();
                            this.populate();
                        }
                        if (this.error != null) {
                            this.completed = true;
                            return this.error;
                        }
                        if (this.partIterator.hasNext()) {
                            return new Result<Part>(this.partIterator.next());
                        }
                        this.completed = true;
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void removeIncompleteUpload(String bucketName, String objectName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        for (Result<Upload> r : this.listIncompleteUploads(bucketName, objectName, true, false)) {
            Upload upload = r.get();
            if (!objectName.equals(upload.objectName())) continue;
            this.abortMultipartUpload(bucketName, objectName, upload.uploadId());
            return;
        }
    }

    public CloseableIterator<Result<NotificationRecords>> listenBucketNotification(String bucketName, String prefix, String suffix, String[] events) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        HashMultimap<String, String> queryParamMap = HashMultimap.create();
        queryParamMap.put("prefix", prefix);
        queryParamMap.put("suffix", suffix);
        for (String event : events) {
            queryParamMap.put("events", event);
        }
        Response response = this.executeGet(bucketName, "", queryParamMap);
        NotificationResultRecords result = new NotificationResultRecords(response);
        return result.closeableIterator();
    }

    public SelectResponseStream selectObjectContent(String bucketName, String objectName, String sqlExpression, InputSerialization is, OutputSerialization os, boolean requestProgress, Long scanStartRange, Long scanEndRange, ServerSideEncryption sse) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        if (bucketName == null || bucketName.isEmpty()) {
            throw new IllegalArgumentException("bucket name cannot be empty");
        }
        this.checkObjectName(objectName);
        this.checkReadRequestSse(sse);
        Map<String, String> headerMap = null;
        if (sse != null) {
            headerMap = sse.headers();
        }
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("select", "");
        queryParamMap.put("select-type", "2");
        SelectObjectContentRequest request = new SelectObjectContentRequest(sqlExpression, requestProgress, is, os, scanStartRange, scanEndRange);
        Response response = this.executePost(bucketName, objectName, headerMap, queryParamMap, request);
        return new SelectResponseStream(response.body().byteStream());
    }

    private long getAvailableSize(Object data, long expectedReadSize) throws IOException, InternalException {
        long totalBytesRead;
        int bytesRead;
        if (!(data instanceof BufferedInputStream)) {
            throw new InternalException("data must be BufferedInputStream. This should not happen.  Please report to https://github.com/minio/minio-java/issues/");
        }
        BufferedInputStream stream = (BufferedInputStream)data;
        stream.mark((int)expectedReadSize);
        byte[] buf = new byte[16384];
        for (totalBytesRead = 0L; totalBytesRead < expectedReadSize; totalBytesRead += (long)bytesRead) {
            long bytesToRead = expectedReadSize - totalBytesRead;
            if (bytesToRead > (long)buf.length) {
                bytesToRead = buf.length;
            }
            if ((bytesRead = stream.read(buf, 0, (int)bytesToRead)) < 0) break;
        }
        stream.reset();
        return totalBytesRead;
    }

    public void setTimeout(long connectTimeout, long writeTimeout, long readTimeout) {
        this.httpClient = this.httpClient.newBuilder().connectTimeout(connectTimeout, TimeUnit.MILLISECONDS).writeTimeout(writeTimeout, TimeUnit.MILLISECONDS).readTimeout(readTimeout, TimeUnit.MILLISECONDS).build();
    }

    @SuppressFBWarnings(value={"SIC"}, justification="Should not be used in production anyways.")
    public void ignoreCertCheck() throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        this.httpClient = this.httpClient.newBuilder().sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }).build();
    }

    public void setAppInfo(String name, String version) {
        if (name == null || version == null) {
            return;
        }
        this.userAgent = DEFAULT_USER_AGENT + " " + name.trim() + "/" + version.trim();
    }

    public void traceOn(OutputStream traceStream) {
        if (traceStream == null) {
            throw new NullPointerException();
        }
        this.traceStream = new PrintWriter((Writer)new OutputStreamWriter(traceStream, StandardCharsets.UTF_8), true);
    }

    public void traceOff() throws IOException {
        this.traceStream = null;
    }

    protected void abortMultipartUpload(String bucketName, String objectName, String uploadId) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put(UPLOAD_ID, uploadId);
        this.executeDelete(bucketName, objectName, queryParamMap);
    }

    protected void completeMultipartUpload(String bucketName, String objectName, String uploadId, Part[] parts) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put(UPLOAD_ID, uploadId);
        CompleteMultipartUpload completeManifest = new CompleteMultipartUpload(parts);
        Response response = this.executePost(bucketName, objectName, null, queryParamMap, completeManifest);
        String bodyContent = "";
        try (ResponseBody body = response.body();){
            bodyContent = new String(body.bytes(), StandardCharsets.UTF_8);
            bodyContent = bodyContent.trim();
        }
        if (!bodyContent.isEmpty()) {
            try {
                if (Xml.validate(ErrorResponse.class, bodyContent)) {
                    ErrorResponse errorResponse = Xml.unmarshal(ErrorResponse.class, bodyContent);
                    throw new ErrorResponseException(errorResponse, response);
                }
            }
            catch (XmlParserException xmlParserException) {
                // empty catch block
            }
        }
    }

    protected String createMultipartUpload(String bucketName, String objectName, Map<String, String> headerMap) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        if (headerMap != null && headerMap.get("Content-Type") == null) {
            headerMap.put("Content-Type", "application/octet-stream");
        }
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("uploads", "");
        Response response = this.executePost(bucketName, objectName, headerMap, queryParamMap, "");
        try (ResponseBody body = response.body();){
            InitiateMultipartUploadResult result = Xml.unmarshal(InitiateMultipartUploadResult.class, body.charStream());
            String string = result.uploadId();
            return string;
        }
    }

    protected DeleteResult deleteObjects(String bucketName, List<DeleteObject> objectList, boolean quiet) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("delete", "");
        DeleteRequest request = new DeleteRequest(objectList, quiet);
        Response response = this.executePost(bucketName, null, null, queryParamMap, request);
        String bodyContent = "";
        try (ResponseBody body = response.body();){
            bodyContent = new String(body.bytes(), StandardCharsets.UTF_8);
        }
        try {
            if (Xml.validate(DeleteError.class, bodyContent)) {
                DeleteError error = Xml.unmarshal(DeleteError.class, bodyContent);
                return new DeleteResult(error);
            }
        }
        catch (XmlParserException xmlParserException) {
            // empty catch block
        }
        return Xml.unmarshal(DeleteResult.class, bodyContent);
    }

    protected ListBucketResult listObjectsV2(String bucketName, String continuationToken, String delimiter, boolean fetchOwner, Integer maxKeys, String prefix, String startAfter, boolean includeUserMetadata) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("list-type", "2");
        if (continuationToken != null) {
            queryParamMap.put("continuation-token", continuationToken);
        }
        if (delimiter != null) {
            queryParamMap.put("delimiter", delimiter);
        } else {
            queryParamMap.put("delimiter", "");
        }
        if (fetchOwner) {
            queryParamMap.put("fetch-owner", "true");
        }
        if (maxKeys != null) {
            queryParamMap.put("max-keys", maxKeys.toString());
        }
        if (prefix != null) {
            queryParamMap.put("prefix", prefix);
        } else {
            queryParamMap.put("prefix", "");
        }
        if (startAfter != null) {
            queryParamMap.put("start-after", startAfter);
        }
        if (includeUserMetadata) {
            queryParamMap.put("metadata", "true");
        }
        Response response = this.executeGet(bucketName, null, null, queryParamMap);
        try (ResponseBody body = response.body();){
            ListBucketResult listBucketResult = Xml.unmarshal(ListBucketResult.class, body.charStream());
            return listBucketResult;
        }
    }

    protected ListBucketResultV1 listObjectsV1(String bucketName, String delimiter, String marker, Integer maxKeys, String prefix) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        if (delimiter != null) {
            queryParamMap.put("delimiter", delimiter);
        } else {
            queryParamMap.put("delimiter", "");
        }
        if (marker != null) {
            queryParamMap.put("marker", marker);
        }
        if (maxKeys != null) {
            queryParamMap.put("max-keys", maxKeys.toString());
        }
        if (prefix != null) {
            queryParamMap.put("prefix", prefix);
        } else {
            queryParamMap.put("prefix", "");
        }
        Response response = this.executeGet(bucketName, null, null, queryParamMap);
        try (ResponseBody body = response.body();){
            ListBucketResultV1 listBucketResultV1 = Xml.unmarshal(ListBucketResultV1.class, body.charStream());
            return listBucketResultV1;
        }
    }

    protected String putObject(String bucketName, String objectName, Object data, int length, Map<String, String> headerMap) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        if (!(data instanceof BufferedInputStream || data instanceof RandomAccessFile || data instanceof byte[] || data instanceof CharSequence)) {
            throw new IllegalArgumentException("data must be BufferedInputStream, RandomAccessFile, byte[] or String");
        }
        Response response = this.executePut(bucketName, objectName, headerMap, null, data, length);
        response.close();
        return response.header("ETag").replaceAll("\"", "");
    }

    protected ListMultipartUploadsResult listMultipartUploads(String bucketName, String delimiter, String keyMarker, Integer maxUploads, String prefix, String uploadIdMarker) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("uploads", "");
        if (delimiter != null) {
            queryParamMap.put("delimiter", delimiter);
        } else {
            queryParamMap.put("delimiter", "");
        }
        if (keyMarker != null) {
            queryParamMap.put("key-marker", keyMarker);
        }
        if (maxUploads != null) {
            queryParamMap.put("max-uploads", Integer.toString(maxUploads));
        }
        if (prefix != null) {
            queryParamMap.put("prefix", prefix);
        } else {
            queryParamMap.put("prefix", "");
        }
        if (uploadIdMarker != null) {
            queryParamMap.put("upload-id-marker", uploadIdMarker);
        }
        Response response = this.executeGet(bucketName, null, null, queryParamMap);
        try (ResponseBody body = response.body();){
            ListMultipartUploadsResult listMultipartUploadsResult = Xml.unmarshal(ListMultipartUploadsResult.class, body.charStream());
            return listMultipartUploadsResult;
        }
    }

    protected ListPartsResult listParts(String bucketName, String objectName, Integer maxParts, Integer partNumberMarker, String uploadId) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        if (maxParts != null) {
            queryParamMap.put("max-parts", Integer.toString(maxParts));
        }
        if (partNumberMarker != null) {
            queryParamMap.put("part-number-marker", Integer.toString(partNumberMarker));
        }
        queryParamMap.put(UPLOAD_ID, uploadId);
        Response response = this.executeGet(bucketName, objectName, null, queryParamMap);
        try (ResponseBody body = response.body();){
            ListPartsResult listPartsResult = Xml.unmarshal(ListPartsResult.class, body.charStream());
            return listPartsResult;
        }
    }

    protected String uploadPart(String bucketName, String objectName, Object data, int length, String uploadId, int partNumber, Map<String, String> headerMap) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        if (!(data instanceof BufferedInputStream || data instanceof RandomAccessFile || data instanceof byte[] || data instanceof CharSequence)) {
            throw new IllegalArgumentException("data must be BufferedInputStream, RandomAccessFile, byte[] or String");
        }
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("partNumber", Integer.toString(partNumber));
        queryParamMap.put(UPLOAD_ID, uploadId);
        Response response = this.executePut(bucketName, objectName, headerMap, queryParamMap, data, length);
        response.close();
        return response.header("ETag").replaceAll("\"", "");
    }

    protected String uploadPartCopy(String bucketName, String objectName, String uploadId, int partNumber, Map<String, String> headerMap) throws InvalidBucketNameException, IllegalArgumentException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, XmlParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("partNumber", Integer.toString(partNumber));
        queryParamMap.put(UPLOAD_ID, uploadId);
        Response response = this.executePut(bucketName, objectName, headerMap, queryParamMap, "", 0);
        try (ResponseBody body = response.body();){
            CopyPartResult result = Xml.unmarshal(CopyPartResult.class, body.charStream());
            String string = result.etag();
            return string;
        }
    }

    static {
        amzHeaders.add("server-side-encryption");
        amzHeaders.add("server-side-encryption-aws-kms-key-id");
        amzHeaders.add("server-side-encryption-context");
        amzHeaders.add("server-side-encryption-customer-algorithm");
        amzHeaders.add("server-side-encryption-customer-key");
        amzHeaders.add("server-side-encryption-customer-key-md5");
        amzHeaders.add("website-redirect-location");
        amzHeaders.add("storage-class");
        standardHeaders = new HashSet<String>();
        standardHeaders.add("content-type");
        standardHeaders.add("cache-control");
        standardHeaders.add("content-encoding");
        standardHeaders.add("content-disposition");
        standardHeaders.add("content-language");
        standardHeaders.add("expires");
        standardHeaders.add("range");
    }

    private static class NotificationResultRecords {
        Response response = null;
        Scanner scanner = null;
        ObjectMapper mapper = null;

        public NotificationResultRecords(Response response) {
            this.response = response;
            this.scanner = new Scanner(response.body().charStream()).useDelimiter("\n");
            this.mapper = new ObjectMapper();
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        }

        public CloseableIterator<Result<NotificationRecords>> closeableIterator() {
            return new CloseableIterator<Result<NotificationRecords>>(){
                String recordsString = null;
                NotificationRecords records = null;
                boolean isClosed = false;

                @Override
                public void close() throws IOException {
                    if (!this.isClosed) {
                        try {
                            response.body().close();
                            scanner.close();
                        }
                        finally {
                            this.isClosed = true;
                        }
                    }
                }

                public boolean populate() {
                    if (this.isClosed) {
                        return false;
                    }
                    if (this.recordsString != null) {
                        return true;
                    }
                    while (scanner.hasNext()) {
                        this.recordsString = scanner.next().trim();
                        if (this.recordsString.equals("")) continue;
                    }
                    if (this.recordsString == null || this.recordsString.equals("")) {
                        try {
                            this.close();
                        }
                        catch (IOException e) {
                            this.isClosed = true;
                        }
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean hasNext() {
                    return this.populate();
                }

                @Override
                public Result<NotificationRecords> next() {
                    if (this.isClosed) {
                        throw new NoSuchElementException();
                    }
                    if ((this.recordsString == null || this.recordsString.equals("")) && !this.populate()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        this.records = mapper.readValue(this.recordsString, NotificationRecords.class);
                        Result<NotificationRecords> result = new Result<NotificationRecords>(this.records);
                        return result;
                    }
                    catch (JsonMappingException e) {
                        Result<NotificationRecords> result = new Result<NotificationRecords>(e);
                        return result;
                    }
                    catch (JsonParseException e) {
                        Result<NotificationRecords> result = new Result<NotificationRecords>(e);
                        return result;
                    }
                    catch (IOException e) {
                        Result<NotificationRecords> result = new Result<NotificationRecords>(e);
                        return result;
                    }
                    finally {
                        this.recordsString = null;
                        this.records = null;
                    }
                }
            };
        }
    }
}

