/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import io.minio.ServerSideEncryption;
import java.util.Collections;
import java.util.Map;

public class PutObjectOptions {
    public static final long MAX_OBJECT_SIZE = 0x50000000000L;
    public static final int MIN_MULTIPART_SIZE = 0x500000;
    public static final long MAX_PART_SIZE = 0x140000000L;
    public static final int MAX_MULTIPART_COUNT = 10000;
    private long objectSize = -1L;
    private long partSize = -1L;
    private int partCount = -1;
    private String contentType = null;
    private Map<String, String> headers = null;
    private ServerSideEncryption sse = null;

    public PutObjectOptions(long objectSize, long partSize) throws IllegalArgumentException {
        if (partSize > 0L) {
            if (partSize < 0x500000L) {
                throw new IllegalArgumentException("part size " + partSize + " is not supported; minimum allowed 5MiB");
            }
            if (partSize > 0x140000000L) {
                throw new IllegalArgumentException("part size " + partSize + " is not supported; maximum allowed 5GiB");
            }
        }
        if (objectSize >= 0L) {
            if (objectSize > 0x50000000000L) {
                throw new IllegalArgumentException("object size " + objectSize + " is not supported; maximum allowed 5TiB");
            }
            this.objectSize = objectSize;
            if (partSize > 0L) {
                if (partSize > objectSize) {
                    partSize = objectSize;
                }
                this.partSize = partSize;
                this.partCount = (int)Math.ceil((double)objectSize / (double)partSize);
                if (this.partCount > 10000) {
                    throw new IllegalArgumentException("object size " + this.objectSize + " and part size " + this.partSize + " make more than " + 10000 + "parts for upload");
                }
            } else {
                double pSize = Math.ceil((double)objectSize / 10000.0);
                pSize = Math.ceil(pSize / 5242880.0) * 5242880.0;
                this.partSize = (long)pSize;
                this.partCount = pSize > 0.0 ? (int)Math.ceil((double)objectSize / pSize) : 1;
            }
            return;
        }
        if (partSize <= 0L) {
            throw new IllegalArgumentException("valid part size must be provided when object size is unknown");
        }
        this.objectSize = -1L;
        this.partSize = partSize;
        this.partCount = -1;
    }

    public void setContentType(String contentType) throws IllegalArgumentException {
        if (contentType == null || contentType.equals("")) {
            throw new IllegalArgumentException("invalid content type");
        }
        this.contentType = contentType;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers != null ? Collections.unmodifiableMap(headers) : null;
    }

    public void setSse(ServerSideEncryption sse) {
        this.sse = sse;
    }

    public long objectSize() {
        return this.objectSize;
    }

    public long partSize() {
        return this.partSize;
    }

    public int partCount() {
        return this.partCount;
    }

    public String contentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        if (this.headers == null || this.headers.get("Content-Type") == null) {
            return "application/octet-stream";
        }
        return this.headers.get("Content-Type");
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public ServerSideEncryption sse() {
        return this.sse;
    }
}

