/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;

class HttpRequestBody
extends RequestBody {
    private RandomAccessFile file = null;
    private BufferedInputStream stream = null;
    private byte[] bytes = null;
    private int length = -1;
    private String contentType = null;

    HttpRequestBody(RandomAccessFile file, int length, String contentType) {
        this.file = file;
        this.length = length;
        this.contentType = contentType;
    }

    HttpRequestBody(BufferedInputStream stream, int length, String contentType) {
        this.stream = stream;
        this.length = length;
        this.contentType = contentType;
    }

    HttpRequestBody(byte[] bytes, int length, String contentType) {
        this.bytes = bytes;
        this.length = length;
        this.contentType = contentType;
    }

    @Override
    public MediaType contentType() {
        MediaType mediaType = null;
        if (this.contentType != null) {
            mediaType = MediaType.parse(this.contentType);
        }
        if (mediaType == null) {
            mediaType = MediaType.parse("application/octet-stream");
        }
        return mediaType;
    }

    @Override
    public long contentLength() {
        return this.length;
    }

    @Override
    public void writeTo(BufferedSink sink) throws IOException {
        if (this.file != null) {
            sink.write(Okio.source(Channels.newInputStream(this.file.getChannel())), (long)this.length);
        } else if (this.stream != null) {
            sink.write(Okio.source(this.stream), (long)this.length);
        } else {
            sink.write(this.bytes, 0, this.length);
        }
    }
}

